package com.sucheasy.entity;

public class Sword {
	private String name; // 武器名
	private int length;// 武器长度
	private String attackType;// 攻击类型
	private static int count; // 掉落数量，阈值锁

	/**
	 * @return the name
	 */
	public String getName() {
		return name;
	}

	/**
	 * @param name the name to set
	 */
	public void setName(String name) {
		this.name = name;
	}

	/**
	 * @return the length
	 */
	public int getLength() {
		return length;
	}

	/**
	 * @param length the length to set
	 */
	public void setLength(int length) {
		this.length = length;
	}

	/**
	 * @return the attackType
	 */
	public String getAttackType() {
		return attackType;
	}

	/**
	 * @param attackType the attackType to set
	 */
	public void setAttackType(String attackType) {
		this.attackType = attackType;
	}

	/**
	 * @return the count
	 */
	public static int getCount() {
		return count;
	}

	/**
	 * @param count the count to set
	 */
	public static void setCount(int count) {
		Sword.count = count;
	}

	public Sword(String name, int length, String attackType) {
		super();
		this.name = name;
		this.length = length;
		this.attackType = attackType;
	}

	public Sword() {
		super();
	}

	// 掉落武器呀
	public synchronized void dropSword(String name, String type) {
		if (this.count >= 5) {
			System.out.println("========游戏内掉落极品达到上限值" + this.count);
			// 让出线程使用权
			try {
				this.wait();

			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		} 
			this.setName(name);
			try {
				Thread.sleep(300);
			} catch (InterruptedException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
			}
			this.setAttackType(type);
			System.out.println("========游戏掉落了一件极品装备：" + type + name);
			this.count++;
		
		super.notify();
	}

	// 回收武器呀
	public synchronized void buyBackSword() {
		if (this.count <= 0) {
			System.out.println("========您没有可以回收的武器了====");
			// 让出线程使用权
			try {
				this.wait();
			} catch (InterruptedException e) {
				e.printStackTrace();
			}
		}

		try {
			Thread.sleep(300);
		} catch (InterruptedException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}

		System.out.println("========系统回收了一件极品装备，请查收回款");
		this.count--;
		super.notify();
	}

}
