import os

# 数据库参数配置
class Config:
    # 配置MySQL参数
    DIALECT = 'mysql'
    DRIVER = 'pymysql'
    NAME = 'root'
    PWD = '123456'
    HOST = 'localhost'
    PORT = 3307
    DATEBASE = 'flask_shop'
    CHARSET = 'utf8mb4'

    SQLALCHEMY_DATABASE_URI = f'{DIALECT}+{DRIVER}://{NAME}:{PWD}@{HOST}:{PORT}/{DATEBASE}?charset={CHARSET}'
    SQLALCHEMY_TRACK_MODIFICATIONS = True
    SECRET_KEY = os.urandom(16)

class DevelopmentConfig(Config):
    DEBUG = True

class ProductionConfig(Config):
    pass

config_map = {
    'develop':DevelopmentConfig,
    'product':ProductionConfig
}