from flask_shop.category import category,category_api,attribute,attribute_api
from flask_shop import models,db
from flask import request
from flask_restful import Resource
# import re
from flask_shop.utils.message import to_status_msg
# from flask_shop.utils.tokens import generate_auth_token,verify_auth_token,login_required

class Category(Resource):
    # 查询商品分类
    def get(self):
        try:
            id = int(request.args.get('id').strip()) if request.args.get('id') else None
            category = models.Category.query.get(id)
            if category:
                return to_status_msg(200,data=category.to_dict(),msg='获取商品分类成功')
            else:
                return to_status_msg(20004)
        except Exception:
            return to_status_msg(20000)
        
    # 增加商品分类
    def post(self):
        try:
            name = request.form.get('name').strip() if request.form.get('name') else ''
            level = int(request.form.get('level').strip()) if request.form.get('level') else None
            pid = int(request.form.get('pid').strip()) if request.form.get('pid') else 0 # 注意：pid是id的外键
            if all([name,level]):
                if pid:
                    category = models.Category(name=name,level=level,pid=pid)
                else:
                    category = models.Category(name=name,level=level)
                db.session.add(category)
                db.session.commit()
                return to_status_msg(200,msg='增加商品分类成功')
            else:
                return to_status_msg(10000)
        except Exception as e:
            print(e)
            return to_status_msg(20000)
    # 修改商品分类
    def put(self):
        try:
            id = int(request.form.get('id').strip()) if request.form.get('id') else None
            name = request.form.get('name').strip() if request.form.get('name') else None
            if all([id,name]):
                category = models.Category.query.get(id)
                if category:
                    category.name = name
                    db.session.commit()
                    return to_status_msg(200,msg='修改商品分类成功')
                else:
                    return to_status_msg(20004)
            return to_status_msg(10000)
        except Exception:
            return to_status_msg(20000)
    # 删除商品分类
    def delete(self):
        try:
            id = int(request.form.get('id').strip()) if request.form.get('id') else None
            if id:
                category = models.Category.query.get(id)
                if category:
                    db.session.delete(category)
                    db.session.commit()
                    return to_status_msg(200,msg='删除商品分类成功')
                return to_status_msg(20004)
            return to_status_msg(10000)
        except Exception:
            return to_status_msg(20000)
        
category_api.add_resource(Category,'/category/')

# 获取商品分类列表树
@category.route('/category_list/')
def get_category_list():
    try:
        level = int(request.args.get('level').strip()) if request.args.get('level') and int(request.args.get('level').strip()) <= 3 else 0
        pnum = int(request.args.get('pnum').strip()) if request.args.get('pnum') else 0
        psize = int(request.args.get('psize').strip()) if request.args.get('psize') else 0

        base_query = models.Category.query.filter(models.Category.level == 1)  #基础查询查第一层
        cate_list = []
        if all([pnum,psize]):   # 分页
            category = base_query.paginate(pnum,psize)
            if level:
                cate_list = get_tree(category.items,level,True)
            else:
                cate_list = get_tree(category.items,level,False)
            data = {
                'pnum': pnum,
                'psize': psize,
                'totalRecord': category.total,
                'data': cate_list
            }
            return to_status_msg(200,data,msg='获取商品分类列表树成功')
        else:                   # 不分页
            category = base_query.all()
            # if level:           # 指定级别
            #     pass
            # else:               # 不指定级别
            #     for first_cate in category:
            #         f_cate = first_cate.to_dict()
            #         f_cate['children'] = []
            #         for second_cate in first_cate.children:
            #             s_cate = second_cate.to_dict()
            #             s_cate['children'] = []
            #             for third_cate in second_cate.children:
            #                 t_cate = third_cate.to_dict()
            #                 s_cate['children'].append(t_cate)
            #             f_cate['children'].append(s_cate)
            #         cate_list.append(f_cate)
            if level:    # 指定级别
                cate_list = get_tree(category,level,True)
            else:   # 不指定级别
                cate_list = get_tree(category,level,False)
            return to_status_msg(200,{'data':cate_list},msg='获取商品分类列表树成功')
    except Exception:
        return to_status_msg(20000)

# 递归算法实现遍历树：
def get_tree(info_list,level,flag):
    cate_list = []
    if info_list:
        for cate in info_list:
            cate_dict = cate.to_dict()
            if flag:
                if cate.level < level:   # 指定级别  递归终止条件
                    cate_dict['children'] = get_tree(cate.children,level,flag)
            else:
                if cate.level != 3:  # 不指定级别  递归终止条件
                    cate_dict['children'] = get_tree(cate.children,level,flag)
            cate_list.append(cate_dict)
    return cate_list

class Attribute(Resource):
    # 分类参数增加接口实现
    def post(self):
        try:
            cid = int(request.form.get('cid').strip()) if request.form.get('cid') else None
            name = request.form.get('name').strip() if request.form.get('name') else None
            _type = request.form.get('_type').strip() if request.form.get('_type') else None
            val = request.form.get('val').strip() if request.form.get('val') else None

            if all([cid,name,_type]):
                if val:
                    attr = models.Attribute(cid=cid,name=name,_type=_type,val=val)
                else:
                    attr = models.Attribute(cid=cid,name=name,_type=_type)
                db.session.add(attr)
                db.session.commit()
                return to_status_msg(200,msg='增加分类参数成功')
            return to_status_msg(10000)
        except Exception:
            return to_status_msg(20000)
    # 分类参数ID获取接口实现
    def get(self):
        try:
            id = int(request.args.get('id').strip()) if request.args.get('id') else None
            if id:
                attr = models.Attribute.query.filter_by(id=id).first()
                if attr:
                    return to_status_msg(200,attr.to_dict(),'获取分类参数成功')
                return to_status_msg(20004)
            return to_status_msg(10000)
        except Exception:
            return to_status_msg(20000)
    # 分类参数更新数据接口实现
    def put(self):
        try:
            id = int(request.form.get('id').strip()) if request.form.get('id') else None
            cid = int(request.form.get('cid').strip()) if request.form.get('cid') else None
            name = request.form.get('name').strip() if request.form.get('name') else None
            val = request.form.get('val').strip() if request.form.get('val') else None

            if all([id,cid,name]):
                attr = models.Attribute.query.get(id)
                if attr:
                    attr.cid = cid
                    attr.name = name
                    attr.val = val
                    db.session.commit()
                    return to_status_msg(200,msg='更新分类参数成功')
                return to_status_msg(20004)
            return to_status_msg(10000)
        except Exception:
            return to_status_msg(20000)
    # 分类参数删除接口实现
    def delete(self):
        try:
            id = int(request.form.get('id').strip()) if request.form.get('id') else None
            if id:
                attr = models.Attribute.query.get(id)
                if attr:
                    db.session.delete(attr)
                    db.session.commit()
                    return to_status_msg(200,attr.to_dict(),msg='删除分类参数成功')
                return to_status_msg(20004)
            return to_status_msg(10000)
        except Exception:
            return to_status_msg(20000)

attribute_api.add_resource(Attribute,'/attribute/')

# 分类参数获取列表接口实现
@attribute.route('/attr_list/')
def get_attr_list():
    try:
        cid = int(request.args.get('cid').strip()) if request.args.get('cid') else None
        _type = request.args.get('_type').strip() if request.args.get('_type') else None
        
        if all([cid,_type]):
            cate = models.Category.query.get(cid)
            if cate:
                attr_list = []
                if _type == 'static':
                    attr_list = [a.to_dict() for a in cate.attrs if a._type == 'static']
                elif _type == 'dynamic':
                    attr_list = [a.to_dict() for a in cate.attrs if a._type == 'dynamic']
                return to_status_msg(200,attr_list,'获取分类参数列表成功')
            return to_status_msg(20004)
        return to_status_msg(10000)
    except Exception:
        return to_status_msg(20000)
