from flask_shop.goods import goods,goods_api
from flask_shop import models,db
from flask import request
from flask_restful import Resource
# import re
from flask_shop.utils.message import to_status_msg
# from flask_shop.utils.tokens import generate_auth_token,verify_auth_token,login_required

# 获取商品列表接口实现
@goods.route('/goods_list/')
def get_goods_list():
    name = request.args.get('name').strip() if request.args.get('name') else None
    if name:
        goods = models.Goods.query.filter(models.Goods.name.like(f'%{name}%')).all()
    else:
        goods = models.Goods.query.all()
    goods_list = [gds.to_dict() for gds in goods]
    return to_status_msg(200,goods_list,'获取商品列表成功')