from flask_shop.role import role,role_api
from flask_shop import models,db
from flask import request
from flask_restful import Resource,reqparse
# import re
from flask_shop.utils.message import to_status_msg
# from flask_shop.utils.tokens import generate_auth_token,verify_auth_token,login_required


class Role(Resource):
    # 获取角色列表接口
    def get(self):
        role_list = []
        try:
            roles = models.Role.query.all()
            role_list = [r.to_dict() for r in roles]
            return to_status_msg(200,role_list,msg='获取角色列表成功')
        except Exception:
            return to_status_msg(20000)
    
    # 增加角色接口
    def post(self):
        try:
            name = request.form.get('name').strip()
            desc = request.form.get('desc').strip()
            if name:
                role = models.Role(name=name,desc=desc)
                db.session.add(role)
                db.session.commit()
                return to_status_msg(200,msg='增加角色成功')
            return to_status_msg(10000)
        except Exception:
            return to_status_msg(20000)
    
    # 删除角色接口
    def delete(self):
        try:
            id = int(request.form.get('id').strip())
            role = models.Role.query.get(id)
            if role:
                db.session.delete(role)
                db.session.commit()
                return to_status_msg(200,msg='删除角色成功')
            return to_status_msg(10019)
        except Exception:
            return to_status_msg(20000)

    # 修改角色接口
    def put(self):
        try:
            id = int(request.form.get('id').strip())
            name = request.form.get('name').strip() if request.form.get('name') else ''
            desc = request.form.get('desc').strip() if request.form.get('desc') else ''
            if name:
                role = models.Role.query.get(id)
                if role:
                    role.name = name
                    role.desc = desc
                    db.session.commit()
                    return to_status_msg(200,msg='修改角色成功')
                return to_status_msg(20002)
            return to_status_msg(10000)
        except Exception:
            return to_status_msg(20000)

# 创建映射关系
role_api.add_resource(Role,'/role/')

# 删除角色权限接口实现
@role.route('/del_menu/<int:rid>/<int:mid>/')
def del_menu(rid,mid):
    try:
        r = models.Role.query.get(rid)  # 根据id获取角色
        m = models.Menu.query.get(mid)  # 根据id获取权限
        if all([r,m]):
            if m in r.menus:  
                r.menus.remove(m)     # 删除角色中的权限
                if m.level == 1:
                    for temp_menu in m.children:  # 遍历当前根节点的子节点
                        if temp_menu in r.menus:  # 判断当前子节点是否在当前权限里
                            r.menus.remove(temp_menu) # 删除子节点
                elif m.level == 2:
                    menus = models.Menu.query.filter_by(pid=m.pid).all()
                    if set(menus).intersection(set(r.menus)) == set():
                        parent_menu = models.Menu.query.filter_by(id=m.pid).all()
                        if set(parent_menu).intersection(set(r.menus)):
                            r.menus=list(set(r.menus).difference(set(parent_menu)))
                db.session.commit()
                # 角色删除优化显示，data=r.get_menu_dict()表示该角色目前拥有的权限
                return to_status_msg(200,data=r.get_menu_dict(),msg='删除权限成功')
            return to_status_msg(20003)
        return to_status_msg(10000)
    except Exception as e:
        print(e)
        return to_status_msg(20000)

# 分配权限接口实现
@role.route('/set_menu/<int:rid>/',methods=['POST'])  #因为前端可能把权限清空，所以路径中不传mids
def set_menu(rid):
    try:
        r = models.Role.query.get(rid)
        mids = request.form.get('mids') # 期望是以逗号分隔的字符串
        if r:                             
            r.menus = []                  # 先清空该角色的权限，避免分配的权限与已有的权限重复
            for mid in mids.split(','):  
                if mid:                  # ''.split(',')返回['']
                    mu = models.Menu.query.get(int(mid))
                    if mu:                 
                        r.menus.append(mu)
                    else:
                        return to_status_msg(20003)
            r.menus = list(set(r.menus))   # 权限去重
            db.session.commit()
            return to_status_msg(200,msg='分配权限成功')
        return to_status_msg(20002)
    except Exception as e:
        print(e)
        return to_status_msg(20000)



