from flask_shop.user import user,user_api
from flask_shop import models,db
from flask import request
from flask_restful import Resource,reqparse
import re
from flask_shop.utils.message import to_status_msg
from flask_shop.utils.tokens import generate_auth_token,verify_auth_token,login_required

@user.route('/')
def index():
    return 'Hello!'

# 用户注册操作
class User(Resource):
    def get(self):
        # 根据id获取用户信息
        try:
            # id = request.args.get('id').strip()  #最好再转换为int,此处不转也不报错
            id = int(request.args.get('id').strip())
            usr  = models.User.query.filter_by(id=id).first()
            if usr:
                return to_status_msg(200,usr.to_dict(),"获取用户成功")
            return to_status_msg(20001)
        except Exception as e:
            print(e)
            return to_status_msg(20000)
        
    def post(self):
        name = request.form.get('name').strip() if request.form.get('pwd') else None
        pwd = request.form.get('pwd').strip() if request.form.get('pwd') else None
        rpwd = request.form.get('rpwd').strip() if request.form.get('rpwd') else None
        nick_name = request.form.get('nick_name').strip() if request.form.get('nick_name') else None
        phone = request.form.get('phone').strip() if request.form.get('phone') else ''
        email = request.form.get('email').strip() if request.form.get('email') else ''

        # 验证数据的正确性
        if not all([name,pwd,rpwd]):
            return to_status_msg(10000)
        if len(name)<2:
            return to_status_msg(10011)
        if len(pwd)<2:
            return to_status_msg(10012)
        if pwd != rpwd:
            return to_status_msg(10013)
        if not re.match(r'^1[34578]\d{9}$',phone):
            return to_status_msg(10014)
        if not re.match(r'^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$',email):
            return to_status_msg(10015)

        # user数据提交到数据库,注意是否已经注册
        try:
            # 注意前端传的参数名
            rid = int(request.form.get('role_name').strip()) if request.form.get('role_name') else 0
            user = models.User(name=name,password=pwd,nick_name=nick_name,phone=phone,email=email,rid=rid) #注意不能写pwd=pwd,因为设置了getter和setter方法
            db.session.add(user)
            db.session.commit()
            return to_status_msg(200)
        except Exception as e:
            print(e)
            return to_status_msg(20000)
        
    # 修改用户信息
    def put(self):
        try:
            id = int(request.form.get('id').strip())
            phone = request.form.get('phone').strip() if request.form.get('phone') else ''
            email = request.form.get('email').strip() if request.form.get('email') else ''
            # 注意前台传的参数名称
            rid = int(request.form.get('role_name').strip()) if request.form.get('role_name') else 0
            usr = models.User.query.get(id)
            if usr:
                if re.match(r'^1[34578]\d{9}$',phone) and re.match(r'^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$',email):
                    usr.phone = phone
                    usr.email = email
                    usr.rid = rid
                    db.session.commit()
                    return to_status_msg(200,msg='修改用户成功')
                elif not re.match(r'^1[34578]\d{9}$',phone) and re.match(r'^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$',email):
                    return to_status_msg(10014)
                elif not re.match(r'^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$',email) and re.match(r'^1[34578]\d{9}$',phone):
                    return to_status_msg(10015)
                else:
                    return [to_status_msg(10014),to_status_msg(10015)]
            else:
                return to_status_msg(10018)
        except Exception as e:
            print(e)
            return to_status_msg(10000)
    
    # 删除用户
    def delete(self):
        try:
            # 注意delete请求获取数据的方法
            # id = int(request.json.get('id').strip()) # 注意这里不能写request.args或request.form,且不能用.strip()
            id = request.json.get('id') # 得到的是整型值，不能用.strip()方法
            usr = models.User.query.get(id)
            if usr:
                db.session.delete(usr)
                db.session.commit()
                return to_status_msg(200,msg="删除用户成功")
            else:
                return to_status_msg(10019)
        except Exception:
            return to_status_msg(20000)
        


user_api.add_resource(User,'/user/')

# 获取用户列表
class UserList(Resource):
    def get(self):
        # 1.创建解析器对象
        parser = reqparse.RequestParser()
        # 2.利用解析器对象添加需要验证的参数
        parser.add_argument('name',type=str)
        parser.add_argument('pnum',type=int)
        parser.add_argument('psize',type=int)
        try:
            # 3. 利用解析器对象进行验证，若正确，直接返回验证后合格的参数值，若错误，抛异常信息给客户端
            args = parser.parse_args()
            name = args.get('name')
            pnum = args.get('pnum') if args.get('pnum') else 1
            psize = args.get('psize') if args.get('psize') else 2
            if name:
                # paginate分页查询
                user_p = models.User.query.filter(models.User.name.like(f'%{name}%')).paginate(pnum,psize)
            else:
                user_p = models.User.query.paginate(pnum,psize)
            data = {
                'pnum':pnum,
                'psize':psize,
                'totalRecord':user_p.total,
                #如果是总的页数，应该是user_p.items.pages
                # 'totalPages':user_p.pages,
                'users':[u.to_dict() for u in user_p.items]
            }
            return to_status_msg(200,data,'获取用户列表成功')
        except Exception as e:
            print(e)
            return to_status_msg(10000)

user_api.add_resource(UserList,'/user_list/')


#用户登录操作
@user.route('/login/',methods=['POST'])
def login():
    name = request.form.get('name')
    pwd = request.form.get('pwd')
    
    if not all([name,pwd]): #只要[]中有一个元素为空，all()方法返回false
        return to_status_msg(10000)
    if len(name)>1:
        user = models.User.query.filter_by(name=name).first() #去数据库中查找
        # print(user)
        if user:
            if user.check_password(pwd):   #校验密码
                token = generate_auth_token(user.id,1000000) #这里的第二个参数单位为毫秒
                # verify_auth_token(token)
                return to_status_msg(200,data={'token':token})
    return to_status_msg(10001)

# 重置密码
@user.route('/reset/',methods=['GET'])
def reset():
    try:
        id = int(request.args.get('id').strip())
        usr = models.User.query.get(id)
        usr.password = '111111'
        db.session.commit()
        return to_status_msg(200,msg="重置密码成功")
    except Exception:
        return to_status_msg(20000)

@user.route('/test/')
@login_required
def test_login_req():
    return to_status_msg(200)