'''
生成token的三要素
1.加密的数据   如uid
2.算法  python模块引入
3.秘钥  flask_app中配置的SECRET_KEY
'''
from itsdangerous import TimedJSONWebSignatureSerializer as Serializer  #算法模块
from flask import current_app,request
from flask_shop.models import User
from functools import wraps
from flask_shop.utils.message import to_status_msg

# 创建token
def generate_auth_token(uid,expiration): #第二个参数是有效期
    # 创建加密对象
    s = Serializer(current_app.config['SECRET_KEY'],expires_in=expiration)
    # 生成token
    return s.dumps({'id':uid}).decode()

# 验证token
def verify_auth_token(token_str):
    # 创建解密对象
    s = Serializer(current_app.config['SECRET_KEY'])
    # token有误会报错
    try:
        data = s.loads(token_str)
    except Exception:
        return None
    # 数据库中查询
    user = User.query.filter_by(id=data['id']).first()
    return user

#登录装饰器，验证token信息
def login_required(view_func):
    @wraps(view_func)
    def verify_token(*args,**kwargs):
        try:
            token = request.headers['token'] # 从请求头中获取token
        except Exception:
            return to_status_msg(10016) #token有误
        # 创建解密对象
        s = Serializer(current_app.config['SECRET_KEY']) #注意，每次重启会生成新的密钥,所以测试时不要重启,测试前下好断点
        # token有误会报错
        try:
            data = s.loads(token) #解析token
        except Exception as e:
            print(e)
            return to_status_msg(10017)  # token过期
        return view_func(*args,**kwargs)
    return verify_token
