#!/usr/bin/env python3
# -*- coding: utf-8 -*-

from pymongo import MongoClient
import pymongo
'''
查询
'''
def do_find():
    # 获取连接数据库对象
    # client = MongoClient() # 默认连接本机的mongo数据库
    client = MongoClient('localhost',27017)
    # 获取数据库实例
    school = client.school
    # 获取集合
    student = school.student
    # 操作集合
    # 查找操作
    # 查找全部
    stus = student.find() #得到一个游标迭代器
    # print(stus) # <pymongo.cursor.Cursor object at 0x03253D18>
    # for stu in stus:
    #     print(stu)
    # print(stus.next())
    # print(stus.next())
    # print(stus.next())
    # 条件查询
    # 查找单个
    # stu = student.find_one({'country':'蜀国'})
    # print(stu)
    # 查找多个
    stus = student.find({'country':'蜀国'})  # 得到一个游标迭代器
    # print(stus) # <pymongo.cursor.Cursor object at 0x03253D18>
    # for stu in stus:
    #     print(stu)
    # print(stus.next())
    # print(stus.next())
    # print(stus.next())
    # 统计记录数
    # num = student.find().count()
    # print(num)
    # 分页查询
    # stus = student.find().limit(6) #前6个
    # stus = student.find().limit(6).skip(6) #跳过前6个的中间6个
    # stus = student.find().skip(6).limit(6) #跳过前6个的中间6个
    # for stu in stus:
    #     print(stu)
    # 查询结果排序
    # stus = student.find().sort('age') #默认升序
    # stus = student.find().sort('age',1) # 升序
    # stus = student.find().sort('age',pymongo.ASCENDING) # 升序
    # stus = student.find().sort('age',-1) # 降序
    stus = student.find().sort('age',pymongo.DESCENDING) #降序
    for stu in stus:
        print(stu)

'''
新增
'''
def do_save():
    # 获取连接数据库对象
    client = MongoClient()
    # 获取数据库实例
    school = client.school
    # 获取集合
    student = school.student
    stu = {'name':'诸葛亮','country':'蜀国'}
    # student.insert(stu) # 更推荐用isert_one和insert_many
    # student.insert_one(stu) # 新增单条记录
    stu2 = {'name':'王平','country':'蜀国'}
    stu3 = {'name':'姜维','country':'蜀国'}
    student.insert_many([stu2,stu3]) # 新增多条记录
'''
更新
'''
def do_update():
    # 获取数据库连接对象
    client = MongoClient()
    # 获取数据库实例
    school = client.school
    # 获取集合
    student = school.student
    args = {'name':'诸葛亮'}
    # student.update_one(args,{'$set':{'age':30}}) # 更新单条记录
    args = {'country':'蜀国'}
    student.update_many(args,{'$set':{'age':30}}) # 更新多条记录

'''
删除
'''
def do_delete():
    # 获取数据库连接对象
    client = MongoClient()
    # 获取数据库实例
    school = client.school
    # 获取集合
    student = school.student
    args = {'name':'诸葛亮'}
    # student.remove(args)# 更推荐用delete_one和delete_many
    # student.delete_one(args) # 删除单条记录
    args= {'country':'吴国'}
    student.delete_many(args) # 删除多条记录

if __name__ == '__main__':
    # do_find()
    # do_save()
    # do_update()
    do_delete()