# Define your item pipelines here
#
# Don't forget to add your pipeline to the ITEM_PIPELINES setting
# See: https://docs.scrapy.org/en/latest/topics/item-pipeline.html


# useful for handling different item types with a single interface
from itemadapter import ItemAdapter
from pymongo import MongoClient
from pymysql import connect

'''
爬虫结果保存到mongo数据库
'''
class ScrapySeventhMongoDemoPipeline:
    def open_spider(self,spider):
        self.client = MongoClient()
        self.db = self.client.movie
        self.maoyan = self.db.maoyan
    def process_item(self, item, spider):
        # print(item)
        self.maoyan.insert(item)
        return item

    def close_spider(self,spider):
        self.client.close()

'''
爬虫结果保存到mysql数据库
'''
class ScrapySeventhMysqlDemoPipeline:
    def open_spider(self,spider):
        self.client = connect(host='localhost',port=3306,user='root',password='123456',database='scrapy_movie',charset='utf8')
        self.cursor = self.client.cursor()
    def process_item(self,item,spider):
        sql = 'insert into t_maoyan values(0,%s,%s)'
        self.cursor.execute(sql,[item['name'],item['view_number']])
        self.client.commit()
        return item
    def close_spider(self,spider):
        self.cursor.close()
        self.client.close()
