import scrapy

'''
注：猫眼有反爬措施
'''
class MaoyanSpider(scrapy.Spider):
    name = 'maoyan'
    allowed_domains = ['maoyan.com']
    start_urls = ['https://maoyan.com/films?showType=2&offset={}'.format(num*30) for num in range(5)]

    def parse(self, response):
        names = response.xpath('//div[@class="channel-detail movie-item-title"]/a/text()').extract()
        view_numbers = [div.xpath('string(.)').extract_first() for div in response.xpath('//div[@class="channel-detail channel-detail-orange"]')]

        for name,view_number in zip(names,view_numbers):
            yield {
                'name':name,
                'view_number':view_number
            }
