import scrapy
from books.items import BooksItem


class BiqugeSpider(scrapy.Spider):
    name = 'biquge'
    allowed_domains = ['xbiquge.la']
    start_urls = ['http://www.xbiquge.la/xiaoshuodaquan/']

    # 取出所有小说名、url
    def parse(self, response):
        book_name = response.xpath('//div[@class="novellist"]/ul/li/a/text()').extract()
        book_url = response.xpath('//div[@class="novellist"]/ul/li/a/@href').extract()

        # 不使用item
        for b, u in zip(book_name, book_url):
            # 不使用item
            # book = {b: u}
            # yield book

            # 使用item
            # item = BooksItem()
            # item['book_name'] = b
            # item['book_url'] = u
            # yield item

            yield scrapy.Request(u, callback=self.directory, meta={'book_name': b, 'book_url': u})

    # 取出目录名、url
    def directory(self, response):
        directorys = response.xpath('//div[@id="list"]/dl/dd/a/text()').extract()
        directorys_url = response.xpath('//div[@id="list"]/dl/dd/a/@href').extract()

        for d, u in zip(directorys, directorys_url):
            print(d)
            print(response.urljoin(u))
            yield scrapy.Request(response.urljoin(u), callback=self.content,
                                 meta={'directorys': d, 'directorys_url': u})

    # 取出内容
    def content(self, response):
        print('我已执行！')
        contents = response.xpath('//div[@id="content"]/text()').extract().strip()  # 去空格
        print(contents)
