from flask import Blueprint
import models
from flask import request
from models import User
from flask_restful import Api,Resource
import re
from exts import db
from utils.tokens import generate_auth_token,verify_auth_token

user_bp = Blueprint('user', __name__, url_prefix="/user")
user_api = Api(user_bp)

@user_bp.route('/')
def user():
    return 'blueprint'


class User_name(Resource):
    def get(self):
        pass

    def post(self):
        uname = request.form.get('uname')
        pwd = request.form.get('pwd')
        real_pwd = request.form.get('real_pwd')
        nick_name = request.form.get('nick_name')
        phone = request.form.get('phone')
        print(type(phone))
        email = request.form.get('email')
        age = request.form.get('age')
        print(type(age))
        gender = request.form.get('gender')
        # 验证数据
        if not all([uname,pwd,real_pwd]):
            return {'msg':'请输入用户名或者密码'}
        if len(uname) <2:
            return {'msg':'用户名不正确'}
        if len(pwd) <2:
            return {'msg':'密码过短'}
        if pwd != real_pwd:
            return {'msg':'两次密码不一致'}
        if not re.match(r'1[3456789]\d{9}',phone):
            return {'msg':'手机号错误'}
        if not re.match(r'^[a-zA-Z0-9_-]+@[a-zA-Z0-9_-]+(\.[a-zA-Z0-9_-]+)+$',email):
            return {'msg':'邮箱格式错误'}
        try:
            user1 = User(uname=uname, password=pwd, nick_name=nick_name, phone=phone,
                         email=email, age=age, gender=gender)
            db.session.add(user1)
            db.session.commit()
            return {'msg':'注册成功'}
        except Exception:
            return {'msg':'用户名重复，注册失败'}


user_api.add_resource(User_name,'/use')


@user_bp.route('/login', methods=["post"])
def login():
    uname = request.form.get('uname')
    pwd = request.form.get('pwd')
    print(type(uname), type(pwd))
    if not all([uname, pwd]):
        return "数据不完整"
    else:
        if len(uname) > 1:
            name = User.query.filter_by(uname=uname).first()
            print(name.id)
            print(type(name))
            if name:
                if name.check_password(pwd):
                    token = generate_auth_token(name.id,1000)
                    # verify_auth_token(token)
                    return '登录成功'
        return '用户名或者密码不正确'
