from flask import Flask
import config
import os
from exts import db
from Blueprints.blueprint import user_bp

app = Flask(__name__)
app.register_blueprint(user_bp)

app.config.from_object(config)
app.config['SQLALCHEMY_DATABASE_URI'] = config.DB_URI
app.config['SQLALCHEMY_TRACK_MODIFICATIONS'] = False
SECRET_KEY = os.urandom(16)
db.init_app(app)

@app.route('/')
def hello_world():
    return 'Hello World!'


if __name__ == '__main__':
    app.run()
