from datetime import datetime
from app import db
from werkzeug.security import generate_password_hash,check_password_hash


class BaseModel:
    create_time = db.Column(db.DateTime,default=datetime.now)
    update_time = db.Column(db.DateTime, default=datetime.now,onupdate=datetime.now)


class User(db.Model,BaseModel):
    __tablename__ = 'user'
    id = db.Column(db.Integer,primary_key=True,autoincrement=True)
    uname = db.Column(db.String(200), nullable=False,unique=True)
    pwd = db.Column(db.String(50))
    nick_name = db.Column(db.String(50))
    phone = db.Column(db.String(50))
    email = db.Column(db.String(50))
    age =db.Column(db.String(20))
    gender = db.Column(db.String(4),default='男')
    country = db.Column(db.String(100))

    def __repr__(self):
        return "%s"%self.uname

    @property
    def password(self):
        return self.pwd

    @password.setter
    def password(self,t_pwd):
        self.pwd = generate_password_hash(t_pwd)

    def check_password(self,t_pwd):
        return check_password_hash(self.pwd,t_pwd)