'''
1，加密的数据  uid
2，算法       python模块
3，密钥
'''

from itsdangerous import TimedJSONWebSignatureSerializer as Serializer
from flask import current_app
from models import User


def generate_auth_token(uid,expiration):
    # 创建加密对象
    s = Serializer(current_app.config['SECRET_KEY'],expires_in = expiration)
    # 生成token
    return s.dumps({'id':uid}).decode()


def verify_auth_token(token_str):
    s = Serializer(current_app.config['SECRET_KEY'])
    try:
        data = s.loads(token_str)
    except Exception:
        return None
    use = User.query.filter_by(id = data['id']).first()
    return use