from flask_shop import db
from werkzeug.security import check_password_hash, generate_password_hash
from datetime import datetime

class BaseModel:
    create_time = db.Column(db.DateTime,default = datetime.now)
    update_time = db.Column(db.DateTime,default = datetime.now)

class User(db.Model):
    __tablename__ = 't_user'
    id = db.Column(db.Integer,primary_key=True)
    name = db.Column(db.String(32),unique=True,nullable=False)
    pwd = db.Column(db.String(128))
    nick_name = db.Column(db.String(32))
    phone = db.Column(db.String(11))
    email = db.Column(db.String(32))

    
    @property
    def password(self):
        return self.pwd

    @password.setter
    def password(self,t_pwd):
        self.pwd = generate_password_hash(t_pwd)

    def check_password(self,t_pwd):
        return check_password_hash(self.pwd,t_pwd)