from flask_shop.user import user,user_api
from flask_shop import models,db
from flask import request
from flask_restful import Resource
import re
from flask_shop.utils.message import to_dict_msg
from flask_shop.utils.tokens import generate_auth_token,verfiy_auth_token,login_required


@user.route('/')
def index():
    return "User Hello!!!"

class User(Resource):
    def get(self):
        pass
    def post(self):
        name = request.form.get('name')
        pwd = request.form.get('pwd')
        real_pwd = request.form.get('real_pwd')
        nick_name = request.form.get('nick_name')
        phone = request.form.get('phone')
        email = request.form.get('email')

        if not all([name,pwd,real_pwd]):
            return to_dict_msg(10000)
        if len(name) < 2:
            return to_dict_msg(10011)
        if len(pwd) < 2:
            return to_dict_msg(10012)  
        if pwd != real_pwd:
            return to_dict_msg(10013)
        if not re.match(r'1[345678]\d{9}',phone): 
            return to_dict_msg(10014)
        if not re.match(r'^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$',email): 
            return to_dict_msg(10015)            
        try:
            usr = models.User(name = name,password = pwd,nick_name = nick_name,phone = phone,email = email)
            db.session.add(usr)
            db.session.commit()
            return{'status':200,'msg':'成功!'}
        except Exception:
            return to_dict_msg(20000)
        
        

user_api.add_resource(User,'/user')   

@user.route('/login',methods=['POST'])
def login():
    name = request.form.get('name')
    pwd = request.form.get('pwd')
    if not all([name,pwd]):
        return {'status':10000,'msg':'数据不完整'}
    if len(name) > 1:
        usr = models.User.query.filter_by(name = name).first()
        if usr:
            if usr.check_password(pwd):
                token =  generate_auth_token(usr.id,1000)
                verfiy_auth_token(token)
                return to_dict_msg(200,data={'token':token})
    return {'status':10001,'msg':'用户名或密码错误'}

@user.route('/test')
@login_required
def text_login_req():
    return to_dict_msg(200)
