package com.xhu.myshiro.config;

import com.xhu.myshiro.listener.MySessionListener;
import com.xhu.myshiro.realm.AdminRealm;
import com.xhu.myshiro.realm.MyRealm;
import org.apache.shiro.authc.credential.HashedCredentialsMatcher;
import org.apache.shiro.authc.pam.AllSuccessfulStrategy;
import org.apache.shiro.authc.pam.AtLeastOneSuccessfulStrategy;
import org.apache.shiro.authc.pam.FirstSuccessfulStrategy;
import org.apache.shiro.authc.pam.ModularRealmAuthenticator;
import org.apache.shiro.codec.Base64;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.realm.jdbc.JdbcRealm;
import org.apache.shiro.session.SessionListener;
import org.apache.shiro.session.mgt.SessionManager;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.CookieRememberMeManager;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.SimpleCookie;
import org.apache.shiro.web.session.mgt.DefaultWebSessionManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import javax.sql.DataSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Configuration
public class ShiroConfig {
    /*@Bean
    public DefaultWebSecurityManager securityManager(JdbcRealm jdbcRealm){
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm(jdbcRealm);
        return securityManager;
    }*/
   /* @Bean
    public JdbcRealm jdbcRealm(DataSource dataSource){
        JdbcRealm jdbcRealm = new JdbcRealm();
        jdbcRealm.setDataSource(dataSource);
        return jdbcRealm;
    }*/
   /* @Bean
    public DefaultWebSecurityManager securityManager(MyRealm myRealm){
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        securityManager.setRealm(myRealm);
        return securityManager;
    }
    @Bean
    public MyRealm myRealm(){
        return new MyRealm();
    }*/
    @Bean
    public DefaultWebSecurityManager securityManager(MyRealm myRealm,
                                                     AdminRealm adminRealm,
                                                     SessionManager sessionManager,
                                                     CookieRememberMeManager cookieRememberMeManager){
        DefaultWebSecurityManager securityManager = new DefaultWebSecurityManager();
        //设置realm管理者
        securityManager.setAuthenticator(modularRealmAuthenticator());
        ArrayList<Realm> realms = new ArrayList<>();
        realms.add(myRealm);
        realms.add(adminRealm);
        securityManager.setRealms(realms);
        securityManager.setSessionManager(sessionManager);
        securityManager.setRememberMeManager(cookieRememberMeManager);
        return securityManager;
    }
    @Bean
    public HashedCredentialsMatcher hashedCredentialsMatcher(){
        HashedCredentialsMatcher hashedCredentialsMatcher = new HashedCredentialsMatcher();
        hashedCredentialsMatcher.setHashAlgorithmName("md5");
        //加密次数
        hashedCredentialsMatcher.setHashIterations(5);
        return hashedCredentialsMatcher;
    }
    @Bean
    public MyRealm myRealm(HashedCredentialsMatcher hashedCredentialsMatcher){
        MyRealm myRealm = new MyRealm();
        myRealm.setCredentialsMatcher(hashedCredentialsMatcher);
        return myRealm;
    }
    @Bean
    public AdminRealm adminRealm(){
        return new AdminRealm();
    }
    //realm管理者
    @Bean
    public ModularRealmAuthenticator modularRealmAuthenticator(){
        ModularRealmAuthenticator modularRealmAuthenticator = new ModularRealmAuthenticator();
        //设置认证策略
        modularRealmAuthenticator.setAuthenticationStrategy(new AtLeastOneSuccessfulStrategy());
        return modularRealmAuthenticator;
    }
    @Bean
    public ShiroFilterFactoryBean shiroFilterFactoryBean(DefaultWebSecurityManager securityManager){
        //1.创建过滤器工厂
        ShiroFilterFactoryBean filterFactory = new ShiroFilterFactoryBean();
        //2.过滤器工厂设置securityManager
        filterFactory.setSecurityManager(securityManager);
        //3.设置shiro的拦截规则
        Map<String,String> filterMap=new HashMap<>();
        //不拦截的资源
        filterMap.put("/login.html","anon");
        filterMap.put("/fail.html","anon");
        filterMap.put("/user/login3","anon");
        filterMap.put("/css/**","anon");
        // 其余资源都需要用户认证  authc表示需要登录认证才能访问   user表示需要登录认证和记住我认证都能访问
      //  filterMap.put("/**","authc");
        filterMap.put("/user/pay","authc");
        filterMap.put("/**","user");
        // 4.将拦截规则设置给过滤器工厂
        filterFactory.setFilterChainDefinitionMap(filterMap);
        // 5.登录页面
        filterFactory.setLoginUrl("/login.html");

        return filterFactory;
    }
    //会话管理器
    @Bean
    public SessionManager sessionManager(MySessionListener mySessionListener){
        //创建会话管理器
        DefaultWebSessionManager sessionManager = new DefaultWebSessionManager();
        //创建会话监听器集合
        List<SessionListener> listeners=new ArrayList<>();
        listeners.add(mySessionListener);
        //将监听器集合设置到会话管理器中
        sessionManager.setSessionListeners(listeners);
        //全局会话超时时间
       // sessionManager.setGlobalSessionTimeout(50000);
        //是否删除无效的session对象,默认为true
        sessionManager.setDeleteInvalidSessions(true);
        //是否开启定时调度器检测过期session,默认为true
        sessionManager.setSessionValidationSchedulerEnabled(true);
        return sessionManager;
    }
    @Bean
    public SimpleCookie simpleCookie(){
        SimpleCookie simpleCookie = new SimpleCookie("rememberMe");
        //Cookie的存活时间
        simpleCookie.setMaxAge(20);
        return simpleCookie;
    }
    @Bean
    public CookieRememberMeManager cookieRememberMeManager(SimpleCookie simpleCookie){
        CookieRememberMeManager cookieRememberMeManager = new CookieRememberMeManager();
        cookieRememberMeManager.setCookie(simpleCookie);
        //Cookie加密的密钥
        cookieRememberMeManager.setCipherKey(Base64.decode("6ZmI6I2j3Y+R1aSn5BOlAA=="));
        return cookieRememberMeManager;
    }
}
