package com.xhu.myshiro.controller;

import com.xhu.myshiro.domain.Users;
import com.xhu.myshiro.service.UsersService;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.*;
import org.apache.shiro.config.IniSecurityManagerFactory;
import org.apache.shiro.mgt.DefaultSecurityManager;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.realm.jdbc.JdbcRealm;
import org.apache.shiro.subject.Subject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import javax.sql.DataSource;

@Controller
public class LoginController {
    @Autowired
    private UsersService usersService;
    @Autowired
    private DataSource dataSource;

    @RequestMapping("/user/login")
    public String login(String username, String password) {
        //1.获取SecurityManager工厂，读取配置文件
        IniSecurityManagerFactory factory = new IniSecurityManagerFactory("classpath:shiro.ini");
        //2.利用工厂获取SecurityManager对象
        SecurityManager securityManager = factory.getInstance();
        //3.将SecurityManager对象设置到运行环境中
        SecurityUtils.setSecurityManager(securityManager);
        //4.获取Subject对象
        Subject subject = SecurityUtils.getSubject();
        //5.将前端传来的用户名密码封装为Shiro提供的身份对象
        UsernamePasswordToken token = new UsernamePasswordToken(username, password);
        try {
            //6.使用shiro认证
            subject.login(token);
            //7.认证通过跳转打主页面
            return "main";
        } catch (AuthenticationException e) {
            //8.认证失败跳转失败页面
            return "fail";
        }
    }

    @RequestMapping("/user/login2")
    public String login2(String username, String password) {
        //1.获取SecurityManager工厂，读取配置文件
        DefaultSecurityManager securityManager = new DefaultSecurityManager();
        //2.为SecurityManager对象设置Realm
        JdbcRealm jdbcRealm = new JdbcRealm();
        jdbcRealm.setDataSource(dataSource);
        securityManager.setRealm(jdbcRealm);
        //3.将SecurityManager对象设置到运行环境中
        SecurityUtils.setSecurityManager(securityManager);
        //4.获取Subject对象
        Subject subject = SecurityUtils.getSubject();
        //5.将前端传来的用户名密码封装为Shiro提供的身份对象
        UsernamePasswordToken token = new UsernamePasswordToken(username, password);
        try {
            //6.使用shiro认证
            subject.login(token);
            //7.认证通过跳转打主页面
            return "main";
        } catch (AuthenticationException e) {
            //8.认证失败跳转失败页面
            return "fail";
        }
    }
    @RequestMapping("/user/login3")
    public String login3(String username, String password,String rememberMe) {
         try {
            //6.使用shiro认证
            usersService.userLogin(username,password,rememberMe);
            //7.认证通过跳转打主页面
            return "main";
        } catch (DisabledAccountException e) {
            //8.认证失败跳转失败页面
             System.out.println("账户失效");
            return "fail";
        }catch (ExpiredCredentialsException e) {
             //8.认证失败跳转失败页面
             System.out.println("凭证过期");
             return "fail";
         }catch (ConcurrentAccessException e) {
             //8.认证失败跳转失败页面
             System.out.println("竞争次数过多");
             return "fail";
         }catch (ExcessiveAttemptsException e) {
             //8.认证失败跳转失败页面
             System.out.println("尝试次数过多");
             return "fail";
         }catch (UnknownAccountException e) {
             //8.认证失败跳转失败页面
             System.out.println("用户名不正确");
             return "fail";
         }catch (IncorrectCredentialsException e) {
             //8.认证失败跳转失败页面
             System.out.println("凭证（密码）不正确 ");
             return "fail";
         }
    }
    @RequestMapping("/user/getUsername")
    @ResponseBody
    public String getUsername(){
        Subject subject = SecurityUtils.getSubject();
        Users users = (Users)subject.getPrincipal();
        return users.getUsername();
    }
    @RequestMapping("/user/logout")
    public String logout(){
        Subject subject = SecurityUtils.getSubject();
        subject.logout();
        return "redirect:/login.html";
    }
    //支付
    @RequestMapping("/user/pay")
    @ResponseBody
    public String pay(){
        return "支付功能";
    }
}
