package com.xhu.myshiro.controller;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.session.Session;
import org.apache.shiro.subject.Subject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

import java.text.SimpleDateFormat;

@Controller
public class SessionController {
    //使用shiro提供的会话对象
    @RequestMapping("/user/session")
    @ResponseBody
    public void session(){
        //1.获取subject对象
        Subject subject = SecurityUtils.getSubject();
        //2.获取会话
        Session session = subject.getSession();
        //输出会话ID
        System.out.println("会话ID: "+session.getId());
        //输出会话的主机地址
        System.out.println("会话的主机地址: "+session.getHost());
        //设置会话过期时间
        session.setTimeout(1000*10);
        //获取会话的过期时间
        System.out.println("会话的过期时间: "+session.getTimeout());
        //会话开始时间
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println("会话开始时间: "+sdf.format(session.getStartTimestamp()));
        //会话的最后访问时间
        System.out.println("会话的最后访问时间: "+sdf.format(session.getLastAccessTime()));
        //在会话中设置数据
        session.setAttribute("name","baizhan");
    }
    @RequestMapping("/user/getSession")
    @ResponseBody
    public void getSession(){
        //1.获取subject对象
        Subject subject = SecurityUtils.getSubject();
        //2.获取会话
        Session session = subject.getSession();

        System.out.println(session.getAttribute("name"));
    }
}
