package com.xhu.myshiro.realm;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.xhu.myshiro.domain.Admin;
import com.xhu.myshiro.domain.Users;
import com.xhu.myshiro.mapper.AdminMapper;
import org.apache.shiro.authc.*;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;

//认证管理员用户的
public class AdminRealm extends AuthorizingRealm {
    @Autowired
    private AdminMapper adminMapper;
    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        return null;
    }
    //认证逻辑
    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        //1.获取用户输入的用户名
        UsernamePasswordToken token= (UsernamePasswordToken)authenticationToken;
        //2.根据用户名查询用户
        String name = token.getUsername();
        //3.将查询的用户封装为身份信息
        QueryWrapper<Admin> wrapper = new QueryWrapper<Admin>().eq("name", name);
        Admin admin = adminMapper.selectOne(wrapper);
        if (admin==null){
            throw  new UnknownAccountException("账户不存在");
        }
        /**
         * 参数1：查询到的用户
         * 参数2：查询到的用户密码
         * 参数3：Realm
         */
        return new SimpleAuthenticationInfo(admin,admin.getPassword(),"adminRealm");
    }
}
