package com.xhu.myshiro.realm;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.xhu.myshiro.domain.Users;
import com.xhu.myshiro.mapper.UsersMapper;
import org.apache.shiro.authc.*;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.util.ByteSource;
import org.springframework.beans.factory.annotation.Autowired;

//自定义realm

public class MyRealm extends AuthorizingRealm{
    @Autowired
    private UsersMapper usersMapper;
    //自定义授权方法
    @Override
    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principalCollection) {
        return null;
    }
    //自定义认证方法
    @Override
    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authenticationToken) throws AuthenticationException {
        //1.获取用户输入的用户名
        UsernamePasswordToken token= (UsernamePasswordToken)authenticationToken;
        //2.根据用户名查询用户
        String username = token.getUsername();
        //3.将查询的用户封装为身份信息
        QueryWrapper<Users> wrapper = new QueryWrapper<Users>().eq("username", username);
        Users users = usersMapper.selectOne(wrapper);
        if (users==null){
            throw  new UnknownAccountException("账户不存在");
        }
        /**
         * 参数1：查询到的用户
         * 参数2：查询到的用户密码
         * 参数3：盐
         * 参数4：Realm
         */
        return new SimpleAuthenticationInfo(users,users.getPassword(), ByteSource.Util.bytes(users.getSalt()),"myRealm");
    }
}
