package com.xhu.myshiro.service;

import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class UsersService {
    @Autowired
    private DefaultWebSecurityManager securityManager;

    public void userLogin(String username,String password,String rememberMe) throws AuthenticationException  {
        //3.将SecurityManager对象设置到运行环境中
        SecurityUtils.setSecurityManager(securityManager);
        //4.获取Subject对象
        Subject subject = SecurityUtils.getSubject();
        //5.将前端传来的用户名密码封装为Shiro提供的身份对象
        UsernamePasswordToken token = new UsernamePasswordToken(username,password);
        if (rememberMe!=null){
            //如果用户选择记住我，则生成记住我Cookie
            token.setRememberMe(true);
        }
        //4.shiro认证
        subject.login(token);
    }
}
